const eventHandlers = new Map<Event, Function>();

export function unregisterEventHandlers(...events: Event[]): void {
    for (const event of events) {
        eventHandlers.delete(event);
    }
}

export function registerEventHandler(event: Event, callback: Function): void {
    eventHandlers.set(event, callback);
}

export function invokeEventHandler(event: Event, ...parameters: unknown[]): void {
    const callback = eventHandlers.get(event);

    if (callback) {
        callback(...parameters);
    }
}

export enum WidgetEvent {
    Add = "add-widget",
    Move = "move-widget",
    Resize = "resize-widget",
    Delete = "delete-widget",
    Rename = "rename-widget",
    Configure = "configure-widget",
    GetWidgets = "get-widgets",
    GetWidget = "get-widget",
    GetAvailableWidgets = "get-available-widgets",
}

export enum ModalEvent {
    Close = "close-modal",
}

export enum AddWidgetModalEvent {
    Open = "open-add-widget-modal",
    Close = "close-add-widget-modal",
    SelectAuthor = "select-author",
    SelectAvailableWidget = "select-available-widget",
    Search = "search-available-widget",
}

export enum EditWidgetModalEvent {
    Open = "open-edit-widget-modal",
    Close = "close-edit-widget-modal",
    UpdateOption = "update-widget-option",
}

export enum DeleteWidgetModalEvent {
    Open = "open-delete-widget-modal",
    Close = "close-delete-widget-modal",
}

export enum LockToggleButtonEvent {
    ToggleLock = "toggle-dashboard-lock",
}

export enum RefreshButtonEvent {
    Refresh = "refresh",
    UpdateRefreshInterval = "update-refresh-interval",
}

export enum ErrorModalEvent {
    Close = "close-error-modal",
}

export type Event =
    | WidgetEvent
    | AddWidgetModalEvent
    | EditWidgetModalEvent
    | DeleteWidgetModalEvent
    | LockToggleButtonEvent
    | RefreshButtonEvent
    | ErrorModalEvent;
